// ---------------------------------------------------------------------------
// Edit this file to define your game. It should have at least four
// sets of content: undum.game.situations, undum.game.start,
// undum.game.qualities, and undum.game.init.
// ---------------------------------------------------------------------------

/* A unique id for your game. This is never displayed. I use a UUID,
 * but you can use anything that is guaranteed unique (a URL you own,
 * or a variation on your email address, for example). */
undum.game.id = "com.eblong.zarf.undum.matter";

/* A string indicating what version of the game this is. Versions are
 * used to control saved-games. If you change the content of a game,
 * the saved games are unlikely to work. Changing this version number
 * prevents Undum from trying to load the saved-game and crashing. */
undum.game.version = "1.0";

// undum.game.isAnimated = false;

function munge_wisdom(val, character) {
    var str, smart1, smart2;
    smart1 = (character.sandbox.oneforest == 'help' || character.sandbox.oneriver == 'help');
    smart2 = (character.sandbox.twoforest == 'help' || character.sandbox.tworiver == 'help');
    if (smart1 && smart2)
        str = 'All three children were wise,';
    else if (smart2)
        str = 'The oldest child was foolish and the younger ones were wise,';
    else if (smart1)
        str = 'The middle child was foolish and other two were wise,';
    else
        str = 'The older two children were foolish and the youngest one was wise,';
    return val.replace("{WISDOM}", str);
}

function munge_monster(val) {
    return val.replace(/{MONSTER\|([^|}]*)\|([^|}]*)\|([^|}]*)\|([^|}]*)}/g, 
        function(orig, grp1, grp2, grp3, grp4) {
            return ('<span class="m_none">' + grp1 + '</span>'
                + '<span class="m_gourd">'  + grp2 + '</span>'
                + '<span class="m_magpie">' + grp3 + '</span>'
                + '<span class="m_squid">'  + grp4 + '</span>');
        });
}

function munge_char(val, flag) {
    return val.replace(/{CHAR\|([^|}]*)\|([^|}]*)}/g, 
        function(orig, grp1, grp2) {
            if (flag == 'm') return grp1;
            if (flag == 'f') return grp2;
            return '???';
        });
}

function munge_onestatus(val) {
    val = val.replace(/{ONEBEGUN\|([^|}]*)\|([^|}]*)}/g, 
        function(orig, grp1, grp2) {
            return ('<span class="one_none">' + grp1 + '</span>'
                + '<span class="one_forest">' + grp2 + '</span>'
                + '<span class="one_river">'  + grp2 + '</span>');
        });
    val = val.replace(/{ONEFOREST\|([^|}]*)\|([^|}]*)}/g, 
        function(orig, grp1, grp2) {
            return ('<span class="one_none">' + grp1 + '</span>'
                + '<span class="one_forest">' + grp2 + '</span>'
                + '<span class="one_river">'  + grp1 + '</span>');
        });
    val = val.replace(/{ONERIVER\|([^|}]*)\|([^|}]*)}/g, 
        function(orig, grp1, grp2) {
            return ('<span class="one_none">' + grp1 + '</span>'
                + '<span class="one_forest">' + grp1 + '</span>'
                + '<span class="one_river">'  + grp2 + '</span>');
        });
    return val;
}

function munge_chapter(val, chap) {
    if (chap == 1) {
        val = val.replace('{CHAP}', 'one');
        return val.replace(/{CHAP\|([^|}]*)\|([^|}]*)}/g, 
            function(orig, grp1, grp2) { return grp1; });
    }
    else if (chap == 2) {
        val = val.replace('{CHAP}', 'two');
        return val.replace(/{CHAP\|([^|}]*)\|([^|}]*)}/g, 
            function(orig, grp1, grp2) { return grp2; });
    }
}

function munge_bothforest(val, flag) {
    if (!flag)
        return val.replace(/{BOTHFOREST\|([^|}]*)\|([^|}]*)}/g, 
            function(orig, grp1, grp2) { return grp1; });
    else
        return val.replace(/{BOTHFOREST\|([^|}]*)\|([^|}]*)}/g, 
            function(orig, grp1, grp2) { 
                return ('<span class="both_forest_f">' + grp1 + '</span>'
                    + '<span class="both_forest_t">'  + grp2 + '</span>');
            });        
}

function munge_bothriver(val, flag) {
    if (!flag)
        return val.replace(/{BOTHRIVER\|([^|}]*)\|([^|}]*)}/g, 
            function(orig, grp1, grp2) { return grp1; });
    else
        return val.replace(/{BOTHRIVER\|([^|}]*)\|([^|}]*)}/g, 
            function(orig, grp1, grp2) { 
                return ('<span class="both_river_f">' + grp1 + '</span>'
                    + '<span class="both_river_t">'  + grp2 + '</span>');
            });        
}

function munge_sword(val, flag) {
    if (!flag)
        return val.replace(/{SWORD}/g, 'sword');
    else
        return val.replace(/{SWORD}/g, 'spear');
}

function munge_words(val, flag) {
    if (!flag) {
        val = val.replace(/{WORDS}/g, 'protection');
        return val.replace(/{WORDS\|([^|}]*)\|([^|}]*)}/g, 
            function(orig, grp1, grp2) { return grp1; });
    }
    else {
        val = val.replace(/{WORDS}/g, 'valor');
        return val.replace(/{WORDS\|([^|}]*)\|([^|}]*)}/g, 
            function(orig, grp1, grp2) { return grp2; });
    }
}

function munge_older(val) {
    return val.replace(/{OLDER\|([^|}]*)\|([^|}]*)}/g, 
        function(orig, grp1, grp2) {
            return ('<span class="older_m">' + grp1 + '</span>'
                + '<span class="older_f">' + grp2 + '</span>');
        });
}

/* The situations that the game can be in. Each has a unique ID. */
undum.game.situations = {
    start: new undum.Situation({
        enter: function(character, system, from) {
            var val = $("#lib_start").html();
            val = munge_monster(val);
            system.write(val);
        }
    }),
    feed_starving: new undum.Situation({
        enter: function(character, system, from) {
            character.sandbox.monster = 'gourd';
            $('#content').removeClass('set_m_none');
            $('#content').addClass('set_m_gourd');
            system.write($("#lib_feed_starving").html());
        }
    }),
    plunder_treasure: new undum.Situation({
        enter: function(character, system, from) {
            character.sandbox.monster = 'magpie';
            $('#content').removeClass('set_m_none');
            $('#content').addClass('set_m_magpie');
            system.write($("#lib_plunder_treasure").html());
        }
    }),
    rescue_captive: new undum.Situation({
        enter: function(character, system, from) {
            character.sandbox.monster = 'squid';
            $('#content').removeClass('set_m_none');
            $('#content').addClass('set_m_squid');
            system.write($("#lib_rescue_captive").html());
        }
    }),

    chapter_two: new undum.Situation({
        enter: function(character, system, from) {
            var valdiv = '<hr id="ch3start" class="section">';
            var val = $("#lib_chapter_two").html();
            system.writeBefore(val+valdiv);
        }
    }),
    chapter_two_m: new undum.Situation({
        enter: function(character, system, from) {
            $('#content').addClass('set_older_m');
            character.sandbox.older = 'm';
            var val = $("#lib_chapter_two_start").html();
            val = munge_char(val, character.sandbox.older);
            system.writeBefore(val, 'ch3start');
        }
    }),
    chapter_two_f: new undum.Situation({
        enter: function(character, system, from) {
            $('#content').addClass('set_older_f');
            character.sandbox.older = 'f';
            var val = $("#lib_chapter_two_start").html();
            val = munge_char(val, character.sandbox.older);
            system.writeBefore(val, 'ch3start');
        }
    }),

    two_forest: new undum.Situation({
        enter: function(character, system, from) {
            var vali = $("#lib_forest_intro_two").html();
            vali = munge_char(vali, character.sandbox.older);
            vali = munge_monster(vali);
            vali = munge_onestatus(vali);

            var val = $("#lib_forest").html();
            val = munge_char(val, character.sandbox.older);
            val = munge_monster(val);
            val = munge_chapter(val, 2);
            val = munge_bothforest(val, true);

            var valo = $("#lib_forest_options_two").html();
            valo = munge_char(valo, character.sandbox.older);

            system.writeBefore(vali+val+valo, 'ch3start');
        }
    }),
    two_forest_ignore: new undum.Situation({
        enter: function(character, system, from) {
            character.sandbox.twoforest = 'ignore';

            var val = $("#lib_forest_ignore").html();
            val = munge_char(val, character.sandbox.older);
            val = munge_monster(val);
            val = munge_chapter(val, 2);
            val = munge_sword(val, false);
            val = val.replace('{TARGET}', 'two_forest_ignore_cont');
            system.writeBefore(val, 'ch3start');
        }
    }),
    two_forest_ignore_cont: new undum.Situation({
        enter: function(character, system, from) {
            var val = $("#lib_forest_ignore_cont").html();
            val = munge_char(val, character.sandbox.older);
            val = munge_bothforest(val, true);
            val = munge_monster(val);
            val = munge_chapter(val, 2);
            val = munge_sword(val, false);
            system.writeBefore(val, 'ch3start');
        }
    }),
    two_forest_ignore_cont2: new undum.Situation({
        enter: function(character, system, from) {
            character.sandbox.gotsword = true;
            $('#content').removeClass('set_sword_none');
            $('#content').addClass('set_sword_1');

            var val = $("#lib_forest_ignore_cont2").html();
            val = munge_char(val, character.sandbox.older);
            val = munge_monster(val);
            val = munge_chapter(val, 2);
            val = munge_sword(val, false);
            system.writeBefore(val, 'ch3start');
        }
    }),
    two_forest_help: new undum.Situation({
        enter: function(character, system, from) {
            character.sandbox.twoforest = 'help';

            var val = $("#lib_forest_help").html();
            val = munge_char(val, character.sandbox.older);
            val = munge_monster(val);
            val = munge_chapter(val, 2);
            val = munge_sword(val, false);
            system.writeBefore(val, 'ch3start');
        }
    }),
    two_forest_help_cont: new undum.Situation({
        enter: function(character, system, from) {
            character.sandbox.gotsword = true;
            $('#content').removeClass('set_sword_none');
            $('#content').addClass('set_sword_1');

            var val = $("#lib_forest_help_cont").html();
            val = munge_char(val, character.sandbox.older);
            val = munge_monster(val);
            val = munge_chapter(val, 2);
            val = munge_sword(val, false);
            system.writeBefore(val, 'ch3start');
        }
    }),

    two_river: new undum.Situation({
        enter: function(character, system, from) {
            var vali = $("#lib_river_intro_two").html();
            vali = munge_char(vali, character.sandbox.older);
            vali = munge_monster(vali);
            vali = munge_onestatus(vali);

            var val = $("#lib_river").html();
            val = munge_char(val, character.sandbox.older);
            val = munge_monster(val);
            val = munge_chapter(val, 2);
            val = munge_bothriver(val, true);

            var valo = $("#lib_river_options_two").html();
            valo = munge_char(valo, character.sandbox.older);

            system.writeBefore(vali+val+valo, 'ch3start');
        }
    }),
    two_river_ignore: new undum.Situation({
        enter: function(character, system, from) {
            character.sandbox.tworiver = 'ignore';

            var val = $("#lib_river_ignore").html();
            val = munge_char(val, character.sandbox.older);
            val = munge_monster(val);
            val = munge_chapter(val, 2);
            val = munge_words(val, false);
            val = val.replace('{TARGET}', 'two_river_ignore_cont');
            system.writeBefore(val, 'ch3start');
        }
    }),
    two_river_ignore_cont: new undum.Situation({
        enter: function(character, system, from) {
            var val = $("#lib_river_ignore_cont").html();
            val = munge_char(val, character.sandbox.older);
            val = munge_bothriver(val, true);
            val = munge_monster(val);
            val = munge_chapter(val, 2);
            val = munge_words(val, false);
            system.writeBefore(val, 'ch3start');
        }
    }),
    two_river_ignore_cont2: new undum.Situation({
        enter: function(character, system, from) {
            character.sandbox.gotprotect = true;
            $('#content').removeClass('set_words_none');
            $('#content').addClass('set_words_1');

            var val = $("#lib_river_ignore_cont2").html();
            val = munge_char(val, character.sandbox.older);
            val = munge_monster(val);
            val = munge_chapter(val, 2);
            val = munge_words(val, false);
            system.writeBefore(val, 'ch3start');
        }
    }),
    two_river_help: new undum.Situation({
        enter: function(character, system, from) {
            character.sandbox.tworiver = 'help';

            var val = $("#lib_river_help").html();
            val = munge_char(val, character.sandbox.older);
            val = munge_monster(val);
            val = munge_chapter(val, 2);
            val = munge_words(val, false);
            system.writeBefore(val, 'ch3start');
        }
    }),
    two_river_help_cont: new undum.Situation({
        enter: function(character, system, from) {
            character.sandbox.gotprotect = true;
            $('#content').removeClass('set_words_none');
            $('#content').addClass('set_words_1');

            var val = $("#lib_river_help_cont").html();
            val = munge_char(val, character.sandbox.older);
            val = munge_monster(val);
            val = munge_chapter(val, 2);
            val = munge_words(val, false);
            system.writeBefore(val, 'ch3start');
        }
    }),

    chapter_two_end: new undum.Situation({
        enter: function(character, system, from) {
            var val = $("#lib_chapter_two_end").html();
            system.write(val);
        }
    }),

    chapter_one: new undum.Situation({
        enter: function(character, system, from) {
            var valdiv = '<hr id="ch2start" class="section">';
            var val = $("#lib_chapter_one").html();
            system.writeBefore(val+valdiv);
        }
    }),
    chapter_one_m: new undum.Situation({
        enter: function(character, system, from) {
            $('#content').addClass('set_oldest_m');
            character.sandbox.oldest = 'm';
            var val = $("#lib_chapter_one_start").html();
            val = munge_char(val, character.sandbox.oldest);
            system.writeBefore(val, 'ch2start');
        }
    }),
    chapter_one_f: new undum.Situation({
        enter: function(character, system, from) {
            $('#content').addClass('set_oldest_f');
            character.sandbox.oldest = 'f';
            var val = $("#lib_chapter_one_start").html();
            val = munge_char(val, character.sandbox.oldest);
            system.writeBefore(val, 'ch2start');
        }
    }),

    one_forest: new undum.Situation({
        enter: function(character, system, from) {
            $('#content').removeClass('set_one_none');
            $('#content').addClass('set_one_forest');
            if (character.sandbox.twoforest)
                $('#content').addClass('set_both_forest');

            var vali = $("#lib_forest_intro_one").html();
            vali = munge_char(vali, character.sandbox.oldest);
            vali = munge_monster(vali);
            vali = munge_onestatus(vali);

            var val = $("#lib_forest").html();
            val = munge_char(val, character.sandbox.oldest);
            val = munge_monster(val);
            val = munge_chapter(val, 1);
            val = munge_bothforest(val, false);

            var valo;
            if (character.sandbox.twoforest == 'ignore')
                valo = $("#lib_forest_options_one_alt").html();
            else
                valo = $("#lib_forest_options_one").html();
            valo = munge_char(valo, character.sandbox.oldest);

            system.writeBefore(vali+val+valo, 'ch2start');
        }
    }),
    one_forest_insult: new undum.Situation({
        enter: function(character, system, from) {
            character.sandbox.oneforest = 'insult';

            var val = $("#lib_forest_insult").html();
            val = munge_char(val, character.sandbox.oldest);
            val = munge_monster(val);
            val = munge_chapter(val, 1);
            val = munge_sword(val, false);
            system.writeBefore(val, 'ch2start');
        }
    }),
    one_forest_ignore: new undum.Situation({
        enter: function(character, system, from) {
            character.sandbox.oneforest = 'ignore';

            var val = $("#lib_forest_ignore").html();
            val = munge_char(val, character.sandbox.oldest);
            val = munge_monster(val);
            val = munge_chapter(val, 1);
            val = munge_sword(val, false);
            if (!character.sandbox.twoforest)
                val = val.replace('{TARGET}', 'one_forest_ignore_cont');
            else
                val = val.replace('{TARGET}', 'chapter_one_end');
            system.writeBefore(val, 'ch2start');
        }
    }),
    one_forest_ignore_cont: new undum.Situation({
        enter: function(character, system, from) {
            var val = $("#lib_forest_ignore_cont").html();
            val = munge_char(val, character.sandbox.oldest);
            val = munge_bothforest(val, false);
            val = munge_monster(val);
            val = munge_chapter(val, 1);
            val = munge_sword(val, false);
            system.writeBefore(val, 'ch3start');
        }
    }),
    one_forest_ignore_cont2: new undum.Situation({
        enter: function(character, system, from) {
            character.sandbox.gotsword = true;
            $('#content').removeClass('set_sword_none');
            $('#content').addClass('set_sword_1');

            var val = $("#lib_forest_ignore_cont2").html();
            val = munge_char(val, character.sandbox.oldest);
            val = munge_monster(val);
            val = munge_chapter(val, 1);
            val = munge_sword(val, false);
            system.writeBefore(val, 'ch3start');
        }
    }),
    one_forest_help: new undum.Situation({
        enter: function(character, system, from) {
            var isspear = (character.sandbox.twoforest == 'help');
            character.sandbox.oneforest = 'help';

            var val = $("#lib_forest_help").html();
            val = munge_char(val, character.sandbox.oldest);
            val = munge_monster(val);
            val = munge_chapter(val, 1);
            val = munge_sword(val, isspear);
            system.writeBefore(val, 'ch2start');
        }
    }),
    one_forest_help_cont: new undum.Situation({
        enter: function(character, system, from) {
            var isspear = (character.sandbox.twoforest == 'help');
            if (!isspear) {
                character.sandbox.gotsword = true;
                $('#content').removeClass('set_sword_none');
                $('#content').addClass('set_sword_1');
            }
            else {
                character.sandbox.gotspear = true;
                $('#content').removeClass('set_sword_1');
                $('#content').addClass('set_sword_2');
                $('#content').removeClass('set_words_none');
                $('#content').addClass('set_words_0');
            }

            var val = $("#lib_forest_help_cont").html();
            val = munge_char(val, character.sandbox.oldest);
            val = munge_monster(val);
            val = munge_chapter(val, 1);
            val = munge_sword(val, isspear);
            system.writeBefore(val, 'ch2start');
        }
    }),

    one_river: new undum.Situation({
        enter: function(character, system, from) {
            $('#content').removeClass('set_one_none');
            $('#content').addClass('set_one_river');
            if (character.sandbox.tworiver)
                $('#content').addClass('set_both_river');

            var vali = $("#lib_river_intro_one").html();
            vali = munge_char(vali, character.sandbox.oldest);
            vali = munge_monster(vali);
            vali = munge_onestatus(vali);

            var val = $("#lib_river").html();
            val = munge_char(val, character.sandbox.oldest);
            val = munge_monster(val);
            val = munge_chapter(val, 1);
            val = munge_bothriver(val, false);

            var valo;
            if (character.sandbox.tworiver == 'ignore')
                valo = $("#lib_river_options_one_alt").html();
            else
                valo = $("#lib_river_options_one").html();
            valo = munge_char(valo, character.sandbox.oldest);

            system.writeBefore(vali+val+valo, 'ch2start');
        }
    }),
    one_river_insult: new undum.Situation({
        enter: function(character, system, from) {
            character.sandbox.oneriver = 'insult';

            var val = $("#lib_river_insult").html();
            val = munge_char(val, character.sandbox.oldest);
            val = munge_monster(val);
            val = munge_chapter(val, 1);
            val = munge_words(val, false);
            system.writeBefore(val, 'ch2start');
        }
    }),
    one_river_ignore: new undum.Situation({
        enter: function(character, system, from) {
            character.sandbox.oneriver = 'ignore';

            var val = $("#lib_river_ignore").html();
            val = munge_char(val, character.sandbox.oldest);
            val = munge_monster(val);
            val = munge_chapter(val, 1);
            val = munge_words(val, false);
            if (!character.sandbox.tworiver)
                val = val.replace('{TARGET}', 'one_river_ignore_cont');
            else
                val = val.replace('{TARGET}', 'chapter_one_end');
            system.writeBefore(val, 'ch2start');
        }
    }),
    one_river_ignore_cont: new undum.Situation({
        enter: function(character, system, from) {
            var val = $("#lib_river_ignore_cont").html();
            val = munge_char(val, character.sandbox.oldest);
            val = munge_bothriver(val, false);
            val = munge_monster(val);
            val = munge_chapter(val, 1);
            val = munge_words(val, false);
            system.writeBefore(val, 'ch3start');
        }
    }),
    one_river_ignore_cont2: new undum.Situation({
        enter: function(character, system, from) {
            character.sandbox.gotprotect = true;
            $('#content').removeClass('set_words_none');
            $('#content').addClass('set_words_1');

            var val = $("#lib_river_ignore_cont2").html();
            val = munge_char(val, character.sandbox.oldest);
            val = munge_monster(val);
            val = munge_chapter(val, 1);
            val = munge_words(val, false);
            system.writeBefore(val, 'ch3start');
        }
    }),
    one_river_help: new undum.Situation({
        enter: function(character, system, from) {
            var isalt = (character.sandbox.tworiver == 'help');
            character.sandbox.oneriver = 'help';

            var val = $("#lib_river_help").html();
            val = munge_char(val, character.sandbox.oldest);
            val = munge_monster(val);
            val = munge_chapter(val, 1);
            val = munge_words(val, isalt);
            system.writeBefore(val, 'ch2start');
        }
    }),
    one_river_help_cont: new undum.Situation({
        enter: function(character, system, from) {
            var isalt = (character.sandbox.tworiver == 'help');
            if (!isalt) {
                character.sandbox.gotprotect = true;
                $('#content').removeClass('set_words_none');
                $('#content').addClass('set_words_1');
            }
            else {
                character.sandbox.gotvalor = true;
                $('#content').removeClass('set_words_1');
                $('#content').addClass('set_words_2');
                $('#content').removeClass('set_sword_none');
                $('#content').addClass('set_sword_0');
            }

            var val = $("#lib_river_help_cont").html();
            val = munge_char(val, character.sandbox.oldest);
            val = munge_monster(val);
            val = munge_chapter(val, 1);
            val = munge_words(val, isalt);
            system.writeBefore(val, 'ch2start');
        }
    }),

    chapter_one_end: new undum.Situation({
        enter: function(character, system, from) {
            if (character.sandbox.oneriver && character.sandbox.tworiver) {
                $('#content').removeClass('set_sword_none');
                $('#content').addClass('set_sword_0');
            }
            if (character.sandbox.oneforest && character.sandbox.twoforest) {
                $('#content').removeClass('set_words_none');
                $('#content').addClass('set_words_0');
            }
            var val = $("#lib_chapter_one_end").html();
            system.write(val);
        }
    }),

    chapter_zero: new undum.Situation({
        enter: function(character, system, from) {
            var val = $("#lib_chapter_zero").html();
            val = munge_wisdom(val, character);
            var valdiv = '<hr id="ch1start" class="section">';
            system.writeBefore(val+valdiv);
        }
    }),

    chapter_zero_battle: new undum.Situation({
        enter: function(character, system, from) {
            character.sandbox.rival = 'battle';
            var val = $("#lib_chapter_zero_battle").html();
            val = munge_monster(val);
            val = munge_wisdom(val, character);
            system.writeBefore(val, 'ch1start');
        }
    }),

    chapter_zero_quest: new undum.Situation({
        enter: function(character, system, from) {
            character.sandbox.rival = 'quest';
            var val = $("#lib_chapter_zero_quest").html();
            val = munge_monster(val);
            val = munge_wisdom(val, character);
            system.writeBefore(val, 'ch1start');
        }
    }),

    chapter_zero_lore: new undum.Situation({
        enter: function(character, system, from) {
            character.sandbox.rival = 'lore';
            var val = $("#lib_chapter_zero_lore").html();
            val = munge_monster(val);
            val = munge_wisdom(val, character);
            system.writeBefore(val, 'ch1start');
        }
    }),

    chapter_zero_end: new undum.Situation({
        enter: function(character, system, from) {
            var val = $("#lib_chapter_zero_end").html();
            val = munge_wisdom(val, character);
            system.write(val);
        }
    }),

    lights_out: new undum.Situation({
        enter: function(character, system, from) {
            $('#content_wrapper').fadeTo(2000, 0.3);
        }
    }),

    dummy_never_happens: new undum.Situation({
        enter: function(character, system, from) {
            var val = '<p>This should never happen.</p>';
            system.write(val);
        }
    })
};

// ---------------------------------------------------------------------------
/* The Id of the starting situation. */
undum.game.start = "start";

// ---------------------------------------------------------------------------
/* Here we define all the qualities that our characters could
 * possess. We don't have to be exhaustive, but if we miss one out then
 * that quality will never show up in the character bar in the UI. */
undum.game.qualities = {
};

// ---------------------------------------------------------------------------
/* The qualities are displayed in groups in the character bar. This
 * determines the groups, their heading (which can be null for no
 * heading) and ordering. QualityDefinitions without a group appear at
 * the end. It is an error to have a quality definition belong to a
 * non-existent group. */
undum.game.qualityGroups = {
};

// ---------------------------------------------------------------------------
/* This function gets run before the game begins. It is normally used
 * to configure the character at the start of play. */
undum.game.init = function(character, system) {
    $('#content').removeClass();  // all classes
    $('#content').addClass('set_m_none');
    $('#content').addClass('set_one_none');
    $('#content').addClass('set_sword_none');
    $('#content').addClass('set_words_none');
};
